# 機能設計書 45-データセット生成（From Tensor/Generator）

## 概要

本ドキュメントは、TensorFlowにおけるデータセット生成機能の設計を記述する。テンソル・ジェネレータ・ファイルからDatasetを生成する機能を提供する。

### 本機能の処理概要

本機能は、様々なデータソース（テンソル、Pythonジェネレータ、ファイル）からtf.data.Datasetインスタンスを生成するための入口となるAPIを提供する。from_tensor_slicesとfrom_generatorが主要な生成メソッドである。

**業務上の目的・背景**：機械学習の入力パイプラインを構築するためには、まずデータソースからDatasetオブジェクトを生成する必要がある。インメモリのテンソルデータからの生成（from_tensor_slices）と、動的にデータを生成するPythonジェネレータからの生成（from_generator）は、最も基本的かつ頻繁に使用されるデータ生成パターンである。

**機能の利用シーン**：（1）Numpy配列やテンソルからデータセットを作成する場面、（2）データベースやカスタムデータソースからジェネレータ経由でデータを供給する場面、（3）RaggedTensorやSparseTensorを含む複雑な構造のデータセットを作成する場面。

**主要な処理内容**：
1. from_tensor_slices: テンソルの第0次元に沿ってスライスし、各スライスを要素とするDatasetを生成
2. from_generator: Pythonジェネレータの各yield値を要素とするDatasetを生成
3. 入力データの正規化（structure.normalize_element）
4. 型仕様の推論（structure.type_spec_from_value）
5. バッチ次元の整合性検証

**関連システム・外部連携**：tf.data.Dataset API（No.44）の一部として機能。TFRecordDataset、TextLineDataset等のファイルベースデータソースとも連携。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに本機能の関連画面なし |

## 機能種別

データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| tensors | Tensor/dict/tuple/list | Yes | from_tensor_slicesの入力 | 非空、第0次元が一致 |
| generator | Callable | Yes | from_generatorの入力ジェネレータ | iter()プロトコルサポート |
| output_types | nested DType | No | from_generatorの出力型（非推奨） | output_signatureと排他 |
| output_shapes | nested TensorShape | No | from_generatorの出力形状（非推奨） | output_signatureと排他 |
| output_signature | nested TypeSpec | No | from_generatorの出力仕様（推奨） | TensorSpec/RaggedTensorSpec等 |
| args | tuple | No | ジェネレータに渡す引数 | None可 |
| name | string | No | データセットの名前 | 英数字とアンダースコアのみ |

### 入力データソース

テンソル、Numpy配列、Pythonジェネレータ関数。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| dataset | tf.data.Dataset | 生成されたデータセットオブジェクト |

### 出力先

tf.dataの変換パイプラインに接続される。

## 処理フロー

### 処理シーケンス

```
1. from_tensor_slicesの場合:
   └─ structure.normalize_element(element)で入力正規化
   └─ type_spec_from_valueで型仕様推論
   └─ to_batched_tensor_listでテンソルリスト化
   └─ 第0次元の整合性検証
   └─ gen_dataset_ops.tensor_slice_datasetでC++カーネル呼出し

2. from_generatorの場合:
   └─ output_signatureまたはoutput_types/output_shapesの検証
   └─ ジェネレータをtf.numpy_functionでラップ
   └─ GeneratorDatasetとして構築
```

### フローチャート

```mermaid
flowchart TD
    A{データソース種別} -->|テンソル| B[from_tensor_slices]
    A -->|ジェネレータ| C[from_generator]
    B --> D[normalize_element]
    D --> E[type_spec_from_value]
    E --> F[バッチ次元検証]
    F --> G[tensor_slice_dataset Op]
    C --> H{output_signature指定?}
    H -->|Yes| I[TypeSpecから型推論]
    H -->|No| J[output_types/shapesから推論]
    I --> K[numpy_functionでラップ]
    J --> K
    K --> L[GeneratorDataset構築]
    G --> M[Dataset返却]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | 第0次元一致 | from_tensor_slicesの入力テンソルは全て同じ第0次元サイズ | from_tensor_slices呼び出し時 |
| BR-45-02 | 空テンソル不可 | from_tensor_slicesの入力は非空であること | from_tensor_slices呼び出し時 |
| BR-45-03 | ジェネレータ制約 | from_generatorはtf.numpy_functionを使用するため、同一プロセスのデバイスに配置が必要 | from_generator使用時 |
| BR-45-04 | output_signature推奨 | from_generatorではoutput_signatureの使用が推奨される（output_types/shapesは非推奨） | from_generator呼び出し時 |

### 計算ロジック

- **from_tensor_slices**: 入力テンソルの第0次元に沿ってスライスし、N個の要素を持つデータセットを生成（N = 第0次元のサイズ）
- **from_generator**: ジェネレータの各yield値をデータセット要素として順次生成

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ValueError | 入力エラー | from_tensor_slicesで空の入力 | 非空のデータを指定 |
| ValueError | 次元不一致 | テンソル間で第0次元が異なる | 全テンソルの第0次元を揃える |

### リトライ仕様

リトライ不要。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

- from_tensor_slicesはテンソルを計算グラフに埋め込むため、大規模データにはTFRecordDatasetの使用を推奨
- from_generatorはPython GILの制約を受けるため、I/Oバウンドの処理に適する

## セキュリティ考慮事項

- from_generatorのbodyはGraphDefにシリアライズされないため、モデル移植性に注意

## 備考

- from_tensor_slicesはis_files引数（内部用）でファイルパスデータセットとしてマークできる
- from_generatorで外部状態に依存する場合、ランタイムが複数回呼び出す可能性がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | from_tensor_slices_op.py | `tensorflow/python/data/ops/from_tensor_slices_op.py` | _TensorSliceDatasetクラスの構造 |

**読解のコツ**: DatasetSourceを継承しており、variant_tensorをC++ Opで生成する。element_specプロパティで要素の型仕様を返す。

#### Step 2: from_tensor_slicesの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | from_tensor_slices_op.py | `tensorflow/python/data/ops/from_tensor_slices_op.py` | _TensorSliceDataset.__init__ |

**主要処理フロー**:
1. **33行目**: structure.normalize_elementで入力を正規化
2. **34行目**: structure.type_spec_from_valueで型仕様推論
3. **35行目**: structure.to_batched_tensor_listでテンソルリスト化
4. **36-37行目**: 非空検証
5. **38-39行目**: _unbatch()でバッチ次元を除去した型仕様生成
6. **42-47行目**: 全テンソルの第0次元の整合性検証
7. **49-53行目**: gen_dataset_ops.tensor_slice_datasetでvariant_tensor生成

#### Step 3: from_generatorの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | from_generator_op.py | `tensorflow/python/data/ops/from_generator_op.py` | _from_generator関数 |

**主要処理フロー**:
- **32-100行目**: _from_generator関数。output_signatureの処理とジェネレータのラップ
- **37-41行目**: tf.numpy_functionの制約（同一プロセスのデバイスに配置が必要）

### プログラム呼び出し階層図

```
tf.data.Dataset.from_tensor_slices(data)
    │
    └─ from_tensor_slices_op._from_tensor_slices(data)
           │
           └─ _TensorSliceDataset.__init__(element)
                  ├─ structure.normalize_element(element)
                  ├─ structure.type_spec_from_value(element)
                  ├─ structure.to_batched_tensor_list(spec, element)
                  ├─ 第0次元検証 (batch_dim.assert_is_compatible_with)
                  └─ gen_dataset_ops.tensor_slice_dataset(tensors, ...)

tf.data.Dataset.from_generator(gen)
    │
    └─ from_generator_op._from_generator(gen, ...)
           │
           ├─ output_signature検証/推論
           ├─ script_ops.numpy_function()でラップ
           └─ _GeneratorDataset構築
```

### データフロー図

```
[入力]                      [処理]                             [出力]

Tensor/ndarray ──────▶ normalize_element ──▶ tensor_slice_dataset Op ──▶ Dataset
                            │
                     type_spec推論
                            │
                     バッチ次元検証

Python Generator ──▶ numpy_function ──▶ GeneratorDataset ──▶ Dataset
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| from_tensor_slices_op.py | `tensorflow/python/data/ops/from_tensor_slices_op.py` | ソース | from_tensor_slicesの実装 |
| from_generator_op.py | `tensorflow/python/data/ops/from_generator_op.py` | ソース | from_generatorの実装 |
| dataset_ops.py | `tensorflow/python/data/ops/dataset_ops.py` | ソース | DatasetV2ベースクラス（DatasetSource含む） |
| structure.py | `tensorflow/python/data/util/structure.py` | ソース | データ構造の正規化・型推論ユーティリティ |
| nest.py | `tensorflow/python/data/util/nest.py` | ソース | ネスト構造のユーティリティ |
| gen_dataset_ops.py | `tensorflow/python/ops/gen_dataset_ops.py` | 自動生成 | C++カーネルへのバインディング |
| script_ops.py | `tensorflow/python/ops/script_ops.py` | ソース | numpy_function（from_generator内部で使用） |
